$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false
    })
    driver.defineSteps([
      {
        element: "#tutorial-step1",
        popover: {
          title: "Campos",
          description:
            "Aqui se encontram os campos essenciais para consultar e gravar as informações.",
          position: "bottom",
        },
      },
      {
        element: '#btnVoltar',
        popover: {
          title: 'Voltar',
          description: 'Aqui está o botão para voltar à consulta.',
          position: 'bottom'
        }
      },
      {
        element: '#btnGravar',
        popover: {
          title: 'Gravar',
          description: 'Aqui está o botão para gravar as informações.',
          position: 'bottom'
        }
      }
    ])
    driver.start()
  })
})

$(document).ready(async function () {
  function carregarItens() {
    $.LoadingOverlay('show')
    retornarDados().then(({ itens }) => {
      ItensCotadosCentralCompras.criarTabelaItens(itens || [])
    }).catch((error) => {
      console.error(error)
      msgErro('Ocorreu um erro ao buscar os dados.')
    }).finally(() => $.LoadingOverlay('hide'))
  }

  async function retornarDados() {
    const response = await requisicao("GET", `/sisplan/centralcompras/v1/retornaritens?`, 'STATUS=C', '', 3600000)

    const json = await response.json()

    if (json) {
      const { resultado, mensagem } = json
      if (mensagem?.codigo !== 200) {
        throw mensagem?.mensagem
      }

      return resultado
    }
  }

  $('#tabelaItens').on('click', '#btnAlterar', async function () {
    const datatableItens = $('#tabelaItens').DataTable()
    const { numero } = datatableItens?.row($(this)?.parents('tr'))?.data()
    const dadosEditar = datatableItens?.data()?.toArray()?.filter((item) => item.numero === numero)
    ModalManutencaoCentralCompras.carregarModalManutencao(dadosEditar, 'C')
  })
  
  $('#tabelaItens').on('click', '#btnInformacoesItem', async function () {
    const datatableItens = $('#tabelaItens').DataTable()
    const { codigo, cor, tamanho, tipoItem } = datatableItens?.row($(this)?.parents('tr'))?.data()
    ModalInformacoesItemCentralCompras.carregarModalInformacoesItem(codigo, cor, tamanho, tipoItem)
  })

  $('#tabelaItens').on('dblclick', 'tr', async function () {
    const { codigo, cor, tamanho, tipoItem } = $('#tabelaItens').DataTable().row($(this)).data()
    ModalInformacoesItemCentralCompras.carregarModalInformacoesItem(codigo, cor, tamanho, tipoItem)
  })

  $("#tabelaItens").on('change', '.checkSel', function () {
    const linha = $(this).closest('tr')
    const isChecked = this.checked
    $(linha).toggleClass('selected', isChecked)
  })

  carregarItens()

  $('#btnVoltar').on('click', function () {
    window.location.href = `${BASE_URI}/central_compras`
  })
})

window.ItensCotadosCentralCompras = window.ItensCotadosCentralCompras || {}

ItensCotadosCentralCompras.atualizarItens = (numero, dadosAtualizados) => {
  const datatable = $('#tabelaItens').DataTable()
  const datatableData = [...datatable.data().toArray().filter(element => element.numero !== numero), ...dadosAtualizados]
  datatableData.sort((a, b) => a.numero.localeCompare(b.numero))
  ItensCotadosCentralCompras.criarTabelaItens(datatableData)
}

ItensCotadosCentralCompras.criarTabelaItens = (data) => {
  if ($.fn.DataTable.isDataTable('#tabelaItens')) {
    $('#tabelaItens').DataTable().destroy()
    $('#tabelaItens').empty()
  }

  const columns = [
    {
      data: 'sel',
      title: `<div class="icheck-primary d-inline">
                <input type="checkbox" id="cbSelAll">
                <label for="cbSelAll"></label>
              </div>
              `,
      render: (_data, _type, _row, { row: rowIndex, col: colIndex }) => (
        `<div class="icheck-primary d-inline">
          <input type="checkbox" id="check_col_${colIndex}_row_${rowIndex}" class="checkSel">
          <label for="check_col_${colIndex}_row_${rowIndex}"></label>
        </div>`
      )
    },
    {
      data: 'numero',
      title: 'Número',
      render: (data) => (
        '<div style="text-align:start;"> ' +
        '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" id="tutorialTabela" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
        '      ' + data + ' ' +
        '    </button> ' +
        '    <div class="dropdown-menu"> ' +
        '    <button class="dropdown-item" type="button" title="Alterar" id="btnAlterar">Alterar</button>     ' +
        '    <button class="dropdown-item" type="button" title="Informações Item" id="btnInformacoesItem">Informações Item</button>     ' +
        '</div>'
      )
    },
    {
      data: 'dataCadastro',
      title: 'Cadastro',
      render(data) {
        return new Intl.DateTimeFormat('pt-BR').format(new Date(`${data.split('T')[0]} 23:59:59`))
      },
    },
    {
      data: 'dataEmissao',
      title: 'Emissão',
      render(data) {
        return new Intl.DateTimeFormat('pt-BR').format(new Date(`${data.split('T')[0]} 23:59:59`))
      },
    },
    {
      data: 'dataEntrega',
      title: 'Entrega',
      render(data) {
        return new Intl.DateTimeFormat('pt-BR').format(new Date(`${data.split('T')[0]} 23:59:59`))
      },
    },
    {
      data: 'dataBaixa',
      title: 'Baixa',
      render(data) {
        return new Intl.DateTimeFormat('pt-BR').format(new Date(`${data.split('T')[0]} 23:59:59`))
      },
    },
    {
      data: 'solicitante',
      title: 'Solicitante',
    },
    {
      data: 'descricaoSolicitante',
      title: 'Descrição Solicitante',
    },
    {
      data: 'prazo',
      title: 'Prazo',
    },
    {
      data: 'descricaoPrazo',
      title: 'Descrição Prazo',
    },
    {
      data: 'colecao',
      title: 'Coleção',
    },
    {
      data: 'descricaoColecao',
      title: 'Descrição Coleção',
    },
    {
      data: 'motivo',
      title: 'Motivo',
    },
    {
      data: 'descricaoMotivo',
      title: 'Descrição Motivo',
    },
    {
      data: 'tipo',
      title: 'Tipo',
    },
    {
      data: 'descricaoTipo',
      title: 'Descrição Tipo',
    },
    {
      data: 'tabelaPreco',
      title: 'Tabela de Preço',
    },
    {
      data: 'descricaoTabelaPreco',
      title: 'Descrição Tabela Preço',
    },
    {
      data: 'centroCusto',
      title: 'Centro de Custo',
    },
    {
      data: 'descricaoCentroCusto',
      title: 'Descrição Centro de Custo',
    },
    {
      data: 'ordem',
      title: 'Ordem',
    },
    {
      data: 'tipoItem',
      title: 'Tipo Item',
    },
    {
      data: 'codigo',
      title: 'Código',
    },
    {
      data: 'descricao',
      title: 'Descrição',
    },
    {
      data: 'cor',
      title: 'Cor',
    },
    {
      data: 'descricaoCor',
      title: 'Descrição Cor',
    },
    {
      data: 'tamanho',
      title: 'Tamanho',
    },
    {
      data: 'descricaoTamanho',
      title: 'Descrição Tamanho',
      visible: false,
    },
    {
      data: 'deposito',
      title: 'Depósito',
    },
    {
      data: 'descricaoDeposito',
      title: 'Descrição Depósito',
    },
    {
      data: 'ordemCompra',
      title: 'O.C.',
    },
    {
      data: 'fornecedorOrdemCompra',
      title: 'Descrição O.C.',
      visible: false,
    },
    {
      data: 'contaContabil',
      title: 'Conta Contábil',
    },
    {
      data: 'descricaoContaContabil',
      title: 'Descrição Conta Contábil',
    },
    {
      data: 'especificacao',
      title: 'Especificação',
    },
    {
      data: 'unidade',
      title: 'Unidade',
    },
    {
      data: 'unidadeCompra',
      title: 'Unidade de Compra',
    },
    {
      data: 'fatorConversao',
      title: 'Fator de Conversão',
    },
    {
      data: 'quantidade',
      title: 'Quantidade',
    },
    {
      data: 'preco',
      title: 'Preço',
    },
    {
      data: 'valor',
      title: 'Valor',
    },
    {
      data: 'status',
      title: 'Situação',
    },
    {
      data: 'observacao',
      title: 'Observação',
    },
    {
      data: 'usuario',
      title: 'Usuário',
    },
    {
      data: 'id',
      title: 'Id',
      visible: false,
    },
  ]

  $('#tabelaItens').DataTable({
    sort: false,
    paging: true,
    destroy: true,
    lengthChange: false,
    filter: false,
    info: false,
    ordering: false,
    sorting: false,
    order: false,
    pageLength: 18,
    colReorder: true,
    language: {
      sEmptyTable: "Nenhum registro encontrado",
      sInfo: "_TOTAL_ registros",
      sInfoEmpty: " 0 registros",
      sInfoFiltered: "(Filtrados de _MAX_ registros)",
      sInfoPostFix: "",
      sInfoThousands: ".",
      sLengthMenu: "_MENU_ resultados",
      sLoadingRecords: "Carregando...",
      sProcessing: "Processando...",
      sZeroRecords: "Nenhum registro encontrado",
      sSearch: "Pesquisar",
      oPaginate: {
        sNext: "Próximo",
        sPrevious: "Anterior",
        sFirst: "Primeiro",
        sLast: "Último",
      },
      oAria: {
        sSortAscending: ": Ordenar colunas de forma ascendente",
        sSortDescending: ": Ordenar colunas de forma descendente",
      },
    },
    autoWidth: true,
    data,
    columns,
    scrollX: true,
    scrollY: '737px',
  })
  ItensCotadosCentralCompras.adicionarEventoSelecionarTodos()
  UtilsCentralCompras.criarContainerBotoes({
    tabela: 'tabelaItens',
  })
  UtilsCentralCompras.habilitarEsconderColunas({
    tabela: 'tabelaItens',
    tela: 'itensCotados'
  })
  UtilsCentralCompras.habilitarExportarCsv({
    tabela: 'tabelaItens',
  })
}

ItensCotadosCentralCompras.adicionarEventoSelecionarTodos = () => {
  $('#cbSelAll').off('change')
  $('#cbSelAll').on('change', function () {
    const isChecked = this.checked
    const table = $('#tabelaItens').DataTable()
    table.rows().every(function () {
      const row = $(this.node())
      row.toggleClass('selected', isChecked)
      const checkbox = row.find('.checkSel')
      checkbox.prop('checked', isChecked)
    })
  })
}